export type WithdrawalStatus = 'in_queue' | 'under_review' | 'in_process' | 'completed' | 'failed' | 'paused';
export type Currency = 'NGN' | 'USD';

export interface Withdrawal {
  id: string;
  vendor_id: string;
  amount: number;
  currency: Currency;
  status: WithdrawalStatus;
  available_on: string;
  reference: string;
  timeline: Array<{ status: WithdrawalStatus; timestamp: string }>;
  created_at: string;
  updated_at: string;
}

export interface WalletSummary {
  pending_earnings: number;
  available_earnings: number;
  currency: Currency;
  last_withdrawal?: string;
}

export interface BankAccount {
  account_number: string;
  bank_name: string;
  account_name: string;
  last_updated_bank_account: string;
}

export interface UpdateBankAccountRequest {
  account_number: string;
  bank_name: string;
  account_name: string;
}

export interface UpdateWithdrawalStatusRequest {
  withdrawals_paused: boolean;
}

export interface UpdateGlobalWithdrawalStatusRequest {
  global_withdrawals_paused: boolean;
} 